/*******************************************************
Filename		:  unit_conversion.sql
Release 		:  c2.0.3
SIR			:  1449
Description		:  Creates the unit conversion table and populates with target unit information.
Author			:  Joseph Wilson
Date			:  05-17-2004
			   06-11-2004 - made dynamic based on contents of TSRUOM table. -JW
			   06-21-2004 - added new units from fix 15 -JW
			   08-02-2004 - updated conversion factors based on CCB feedback -JW
			   08-04-2004 - correct target unit from ppm to ppb -JW
Comments		:  Shift for temperature conversions is handled in the DATA2 scripts.
**********************************************************/
set echo off
spool unit_conversion.log

DROP TABLE lu_unit_conversion;

CREATE TABLE lu_unit_conversion (
	PK_ISN			NUMBER(12),
	--TSRUOM_ORG_ID		CHAR(8),
	UOM_TYPE		CHAR(5),
	SHORT_FORM_NAME		CHAR(10),
	DESCRIPTION_TEXT	VARCHAR2(50),
	TARGET_UNIT		CHAR(10),
	CONVERSION_FACTOR	NUMBER
	) tablespace STORETDATA;

--Copy contents of UOM table
INSERT INTO lu_unit_conversion (pk_isn, uom_type, short_form_name, description_text)
	(SELECT TSRUOM_IS_NUMBER, UOM_TYPE, SHORT_FORM_NAME, DESCRIPTION_TEXT FROM STORET.TSRUOM);

COMMIT;

--CREATE INDEX 
alter table lu_unit_conversion
	add constraint pk_unit_conv primary key (PK_ISN)
	using index;

--Add target unit and conversion factor columns to the lu_unit_conversion table
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.000001 where pk_isn = 190;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.0001 where pk_isn = 191;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 1 where pk_isn = 192;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 1000000 where pk_isn = 193;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.83612736 where pk_isn = 197;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 4046.8564224 where pk_isn = 199;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 3429904 where pk_isn = 274;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.01 where pk_isn = 273;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 2589988.110336 where pk_isn = 198;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.09290304 where pk_isn = 196;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 0.00064516 where pk_isn = 195;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm2',CONVERSION_FACTOR = 10000 where pk_isn = 194;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'drips/min',CONVERSION_FACTOR = 1 where pk_isn = 241;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 35.31467 where pk_isn = 239;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000004087345685 where pk_isn = 240;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000115740740741 where pk_isn = 140;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0166666666666667 where pk_isn = 139;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 1 where pk_isn = 138;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.00003531467 where pk_isn = 141;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000000098096296 where pk_isn = 143;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0005885777786915 where pk_isn = 145;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 1.54722865226337 where pk_isn = 151;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000015472286522 where pk_isn = 150;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000371334876543 where pk_isn = 149;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0022280092592592 where pk_isn = 148;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.133680555555556 where pk_isn = 147;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000098096296449 where pk_isn = 146;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0353146667214886 where pk_isn = 144;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0000005885777786 where pk_isn = 142;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.00423608088930031 where pk_isn = 153;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0508329706716038 where pk_isn = 152;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.0098096305555555 where pk_isn = 255;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfs',CONVERSION_FACTOR = 0.588577833333333 where pk_isn = 254;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 190.4794272 where pk_isn = 158;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.000002204623 where pk_isn = 157;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.000052910952 where pk_isn = 156;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.00317465712 where pk_isn = 155;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.1904794272 where pk_isn = 154;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 1 where pk_isn = 165;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 24 where pk_isn = 164;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 1440 where pk_isn = 163;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 86400 where pk_isn = 162;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.002204623 where pk_isn = 161;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 0.052910952 where pk_isn = 160;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 3.17465712 where pk_isn = 159;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'per m',CONVERSION_FACTOR = 1 where pk_isn = 238;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'nu',CONVERSION_FACTOR = 1 where pk_isn = 71;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0000000393700787 where pk_isn = 60;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0393700787401575 where pk_isn = 61;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.0000000039370079 where pk_isn = 59;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 0.393700787401575 where pk_isn = 62;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 39.3700787401575 where pk_isn = 64;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 1 where pk_isn = 66;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 36 where pk_isn = 68;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 72913.38588 where pk_isn = 70;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 63360 where pk_isn = 69;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 12 where pk_isn = 67;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 39370.0787401575 where pk_isn = 65;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'in',CONVERSION_FACTOR = 3.93700787401575 where pk_isn = 63;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'None',CONVERSION_FACTOR = 1 where pk_isn = 1;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'TU',CONVERSION_FACTOR = 1 where pk_isn = 266;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mmol/m2/dy',CONVERSION_FACTOR = 1 where pk_isn = 277;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mmol/m2/dy',CONVERSION_FACTOR = 24 where pk_isn = 246;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 1 where pk_isn = 50;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 24 where pk_isn = 49;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 1000 where pk_isn = 52;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m3/day',CONVERSION_FACTOR = 24000 where pk_isn = 51;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 10 where pk_isn = 253;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 2.7378507871321 where pk_isn = 58;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 0.306871064953512 where pk_isn = 57;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 1000 where pk_isn = 56;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 24000 where pk_isn = 55;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 1 where pk_isn = 54;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/m2/day',CONVERSION_FACTOR = 24 where pk_isn = 53;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000000000001 where pk_isn = 2;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000000001 where pk_isn = 3;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.000001 where pk_isn = 4;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 0.001 where pk_isn = 5;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1 where pk_isn = 6;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1000 where pk_isn = 7;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 28.349523125 where pk_isn = 8;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 453.59237 where pk_isn = 9;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 907184.74 where pk_isn = 10;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g',CONVERSION_FACTOR = 1000000 where pk_isn = 11;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where pk_isn = 48;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where pk_isn = 47;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Mole/l',CONVERSION_FACTOR = 1 where pk_isn = 45;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 1000 where pk_isn = 46;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 1 where pk_isn = 205;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'meq/L',CONVERSION_FACTOR = 0.001 where pk_isn = 204;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mmol/kg',CONVERSION_FACTOR = 1 where pk_isn = 247;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mmol/kg',CONVERSION_FACTOR = 0.000001 where pk_isn = 256;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'umol/m2/dy',CONVERSION_FACTOR = 86.4 where pk_isn = 265;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'umol',CONVERSION_FACTOR = 1 where pk_isn = 264;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'umol/S/m2',CONVERSION_FACTOR = 1 where pk_isn = 261;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1000 where pk_isn = 245;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000001 where pk_isn = 12;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where pk_isn = 13;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where pk_isn = 14;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where pk_isn = 15;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000000001 where pk_isn = 16;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.000001 where pk_isn = 17;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where pk_isn = 18;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where pk_isn = 19;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where pk_isn = 20;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where pk_isn = 21;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where pk_isn = 244;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000000 where pk_isn = 243;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where pk_isn = 242;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 0.001 where pk_isn = 22;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1 where pk_isn = 23;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000 where pk_isn = 24;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000 where pk_isn = 25;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 1000000000 where pk_isn = 26;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 17118.0600684945 where pk_isn = 279;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/l',CONVERSION_FACTOR = 735462.367317422 where pk_isn = 252;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 25400 where pk_isn = 105;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 13595.0980644332 where pk_isn = 104;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 345315.576675011 where pk_isn = 103;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 703069.579991084 where pk_isn = 102;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 101.971621297792 where pk_isn = 109;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 13595.0980644332 where pk_isn = 108;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 10332274.5279988 where pk_isn = 107;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1000 where pk_isn = 106;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1000 where pk_isn = 32;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 1 where pk_isn = 31;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.001 where pk_isn = 30;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000001 where pk_isn = 29;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000000001 where pk_isn = 28;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'g/m2',CONVERSION_FACTOR = 0.000000000001 where pk_isn = 27;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.0003238315531757 where pk_isn = 122;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 1 where pk_isn = 121;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.001 where pk_isn = 120;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.251995761068425 where pk_isn = 119;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kcal',CONVERSION_FACTOR = 0.0002388458966275 where pk_isn = 118;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.000746 where pk_isn = 117;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 1 where pk_isn = 116;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.001 where pk_isn = 115;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mw',CONVERSION_FACTOR = 0.000001 where pk_isn = 114;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'TON',CONVERSION_FACTOR = 1 where pk_isn = 268;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'units/cm',CONVERSION_FACTOR = 1 where pk_isn = 278;
UPDATE lu_unit_conversion SET TARGET_UNIT = '% by vol',CONVERSION_FACTOR = 1 where pk_isn = 101;
UPDATE lu_unit_conversion SET TARGET_UNIT = '% by wt',CONVERSION_FACTOR = 1 where pk_isn = 100;
UPDATE lu_unit_conversion SET TARGET_UNIT = '%',CONVERSION_FACTOR = 1 where pk_isn = 99;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'PSS',CONVERSION_FACTOR = 1 where pk_isn = 263;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ADMI value',CONVERSION_FACTOR = 1 where pk_isn = 259;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'fibers/l',CONVERSION_FACTOR = 1 where pk_isn = 218;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'PCU',CONVERSION_FACTOR = 1 where pk_isn = 208;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/day',CONVERSION_FACTOR = 2000 where pk_isn = 249;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.001 where pk_isn = 38;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1 where pk_isn = 39;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000000 where pk_isn = 41;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000 where pk_isn = 40;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000000 where pk_isn = 37;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1000 where pk_isn = 36;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 1 where pk_isn = 35;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.001 where pk_isn = 34;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ug/kg',CONVERSION_FACTOR = 0.000001 where pk_isn = 33;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 0.00027777777777778 where pk_isn = 137;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 0.0166666666666667 where pk_isn = 136;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Deg',CONVERSION_FACTOR = 1 where pk_isn = 135;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uE/m2/sec',CONVERSION_FACTOR = 1 where pk_isn = 134;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ft-candles',CONVERSION_FACTOR = 1 where pk_isn = 130;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'JCU',CONVERSION_FACTOR = 1 where pk_isn = 129;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'NTU',CONVERSION_FACTOR = 1 where pk_isn = 128;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'JTU',CONVERSION_FACTOR = 1 where pk_isn = 127;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'FTU',CONVERSION_FACTOR = 1 where pk_isn = 126;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where pk_isn = 133;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where pk_isn = 132;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lumens',CONVERSION_FACTOR = 1 where pk_isn = 131;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000000 where pk_isn = 267;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000000 where pk_isn = 44;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1000 where pk_isn = 43;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'ppb',CONVERSION_FACTOR = 1 where pk_isn = 42;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'lb/in',CONVERSION_FACTOR = 1 where pk_isn = 125;
UPDATE lu_unit_conversion SET TARGET_UNIT = '% sediment',CONVERSION_FACTOR = 1 where pk_isn = 216;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'gpm/ft',CONVERSION_FACTOR = 1 where pk_isn = 124;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Langleys',CONVERSION_FACTOR = 1 where pk_isn = 123;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'amps',CONVERSION_FACTOR = 1 where pk_isn = 113;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'volts',CONVERSION_FACTOR = 1 where pk_isn = 112;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'volts',CONVERSION_FACTOR = 0.001 where pk_isn = 210;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1 where pk_isn = 111;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1000000 where pk_isn = 110;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1000 where pk_isn = 207;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 1 where pk_isn = 206;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'uS/cm',CONVERSION_FACTOR = 10000 where pk_isn = 262;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mrem/day',CONVERSION_FACTOR = 1 where pk_isn = 215;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mrem/day',CONVERSION_FACTOR = 0.0027378507871321 where pk_isn = 214;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 3.22 where pk_isn = 272;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1 where pk_isn = 211;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1000 where pk_isn = 248;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 1000 where pk_isn = 271;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/L',CONVERSION_FACTOR = 0.001 where pk_isn = 213;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/g',CONVERSION_FACTOR = 1 where pk_isn = 212;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pCi/m2',CONVERSION_FACTOR = 1 where pk_isn = 209;
UPDATE lu_unit_conversion SET TARGET_UNIT = '% Cover',CONVERSION_FACTOR = 1 where pk_isn = 203;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'MPN',CONVERSION_FACTOR = 1 where pk_isn = 73;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'count',CONVERSION_FACTOR = 1 where pk_isn = 72;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'Plate cnt',CONVERSION_FACTOR = 1 where pk_isn = 90;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'cfu/100ml',CONVERSION_FACTOR = 1 where pk_isn = 257;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'CFU',CONVERSION_FACTOR = 1 where pk_isn = 74;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.2 where pk_isn = 251;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.0002641721 where pk_isn = 250;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 100 where pk_isn = 75;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 1 where pk_isn = 76;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.1 where pk_isn = 77;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 1 where pk_isn = 78;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 100 where pk_isn = 79;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/100ml',CONVERSION_FACTOR = 0.0001 where pk_isn = 80;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0000003861022 where pk_isn = 89;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0002471043692253 where pk_isn = 88;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1.19599004630108 where pk_isn = 87;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 10.7639104167097 where pk_isn = 86;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1550.0031000062 where pk_isn = 85;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.0001 where pk_isn = 84;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 0.000001 where pk_isn = 83;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 1 where pk_isn = 82;
UPDATE lu_unit_conversion SET TARGET_UNIT = '#/m2',CONVERSION_FACTOR = 10000 where pk_isn = 81;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 1 where pk_isn = 200;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 1 where pk_isn = 202;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'deg C',CONVERSION_FACTOR = 0.555555555555555 where pk_isn = 201;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 0.0000166666666667 where pk_isn = 91;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 60 where pk_isn = 94;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 10080 where pk_isn = 96;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 525960 where pk_isn = 98;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 43830 where pk_isn = 97;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 1440 where pk_isn = 95;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 1 where pk_isn = 93;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'minutes',CONVERSION_FACTOR = 0.0166666666666667 where pk_isn = 92;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.01 where pk_isn = 166;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.277777777777777 where pk_isn = 171;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.514444444444444 where pk_isn = 173;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.0000035277777778 where pk_isn = 174;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.44704 where pk_isn = 172;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.00508 where pk_isn = 170;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 1 where pk_isn = 167;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 1000 where pk_isn = 168;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm/sec',CONVERSION_FACTOR = 0.3048 where pk_isn = 169;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 0.000000001 where pk_isn = 269;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1000 where pk_isn = 276;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mm3/l',CONVERSION_FACTOR = 1 where pk_isn = 275;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'drops',CONVERSION_FACTOR = 1 where pk_isn = 178;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.001 where pk_isn = 175;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000001 where pk_isn = 176;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 1233.489 where pk_isn = 189;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.00454609 where pk_isn = 188;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.003785412 where pk_isn = 187;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0009463529 where pk_isn = 186;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0004731765 where pk_isn = 185;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.764544857984 where pk_isn = 184;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.028316846592 where pk_isn = 183;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000016387064 where pk_isn = 182;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.0001 where pk_isn = 177;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 0.000001 where pk_isn = 180;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'm3',CONVERSION_FACTOR = 1 where pk_isn = 181;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'pfu/100ml',CONVERSION_FACTOR = 1 where pk_isn = 281;
UPDATE lu_unit_conversion SET TARGET_UNIT = '% CaCO3',CONVERSION_FACTOR = 1 where pk_isn = 282;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'mg/l CaCO3',CONVERSION_FACTOR = 1 where pk_isn = 283;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'kg/t CaCO3',CONVERSION_FACTOR = 1 where pk_isn = 284;
UPDATE lu_unit_conversion SET TARGET_UNIT = 'tCaCO3/Kt',CONVERSION_FACTOR = 1 where pk_isn = 285;

COMMIT;

--set to default values when no target_unit or conversion factor has been specified
UPDATE lu_unit_conversion SET TARGET_UNIT = short_form_name, CONVERSION_FACTOR = 1 where target_unit is null;

COMMIT;

SPOOL OFF
